/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.BinaryColumnType;
import org.jetbrains.exposed.sql.BlobColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010%\u001a\u00020$\u0012\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b.\u0010/J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u0015\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ \u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR(\u0010!\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0016\u0010#\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\rR\u0017\u0010%\u001a\u00020$8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u0017\u0010*\u001a\u00020)8\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\u00a8\u00060"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcPreparedStatementImpl;", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "", "addBatch", "()V", "cancel", "closeIfPossible", "", "", "executeBatch", "()Ljava/util/List;", "Ljava/sql/ResultSet;", "executeQuery", "()Ljava/sql/ResultSet;", "executeUpdate", "()I", "index", "", "value", "set", "(ILjava/lang/Object;)V", "Ljava/io/InputStream;", "inputStream", "setInputStream", "(ILjava/io/InputStream;)V", "Lorg/jetbrains/exposed/sql/IColumnType;", "columnType", "setNull", "(ILorg/jetbrains/exposed/sql/IColumnType;)V", "getFetchSize", "()Ljava/lang/Integer;", "setFetchSize", "(Ljava/lang/Integer;)V", "fetchSize", "getResultSet", "resultSet", "Ljava/sql/PreparedStatement;", "statement", "Ljava/sql/PreparedStatement;", "getStatement", "()Ljava/sql/PreparedStatement;", "", "wasGeneratedKeysRequested", "Z", "getWasGeneratedKeysRequested", "()Z", "<init>", "(Ljava/sql/PreparedStatement;Z)V", "exposed-jdbc"})
public final class JdbcPreparedStatementImpl
implements PreparedStatementApi {
    @NotNull
    private final PreparedStatement statement;
    private final boolean wasGeneratedKeysRequested;

    public JdbcPreparedStatementImpl(@NotNull PreparedStatement statement, boolean wasGeneratedKeysRequested) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this.statement = statement;
        this.wasGeneratedKeysRequested = wasGeneratedKeysRequested;
    }

    @NotNull
    public final PreparedStatement getStatement() {
        return this.statement;
    }

    public final boolean getWasGeneratedKeysRequested() {
        return this.wasGeneratedKeysRequested;
    }

    @Override
    @Nullable
    public ResultSet getResultSet() {
        return this.wasGeneratedKeysRequested ? this.statement.getGeneratedKeys() : this.statement.getResultSet();
    }

    @Override
    @Nullable
    public Integer getFetchSize() {
        return this.statement.getFetchSize();
    }

    @Override
    public void setFetchSize(@Nullable Integer value2) {
        Integer n = value2;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.getStatement().setFetchSize(value2);
        }
    }

    @Override
    public void addBatch() {
        this.statement.addBatch();
    }

    @Override
    @NotNull
    public ResultSet executeQuery() {
        ResultSet resultSet = this.statement.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"statement.executeQuery()");
        return resultSet;
    }

    @Override
    public int executeUpdate() {
        return this.statement.executeUpdate();
    }

    @Override
    public void set(int index, @NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.statement.setObject(index, value2);
    }

    @Override
    public void setNull(int index, @NotNull IColumnType columnType) {
        Intrinsics.checkNotNullParameter((Object)columnType, (String)"columnType");
        if (columnType instanceof BinaryColumnType || columnType instanceof BlobColumnType) {
            this.statement.setNull(index, -4);
        } else {
            this.statement.setObject(index, null);
        }
    }

    @Override
    public void setInputStream(int index, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.statement.setBinaryStream(index, inputStream, inputStream.available());
    }

    @Override
    public void closeIfPossible() {
        if (!this.statement.isClosed()) {
            this.statement.close();
        }
    }

    @Override
    @NotNull
    public List<Integer> executeBatch() {
        int[] nArray = this.statement.executeBatch();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"statement.executeBatch()");
        return ArraysKt.toList((int[])nArray);
    }

    @Override
    public void cancel() {
        if (!this.statement.isClosed()) {
            this.statement.cancel();
        }
    }

    @Override
    public int fillParameters(@NotNull Iterable<? extends Pair<? extends IColumnType, ? extends Object>> args) {
        return PreparedStatementApi.DefaultImpls.fillParameters(this, args);
    }
}

